
/* berkd.c include file */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <sys/time.h>
#include <termios.h>
#include <syslog.h>
#include <signal.h>
#include <errno.h>

/* Watchdog command bytes */

#define WATCHDOG_RESET_NOW		(unsigned char)0x20
#define WATCHDOG_RESET_SOON		(unsigned char)0x21
#define WATCHDOG_ARM			(unsigned char)0x24
#define WATCHDOG_DISABLE		(unsigned char)0x28
#define WATCHDOG_ENABLE			(unsigned char)0x29
#define WATCHDOG_REV_MAJOR		(unsigned char)0x30
#define WATCHDOG_REV_MINOR		(unsigned char)0x31
#define WATCHDOG_NOP			(unsigned char)0x34
#define WATCHDOG_RESETCOUNT		(unsigned char)0x38
#define WATCHDOG_CLEARRESET		(unsigned char)0x39
#define WATCHDOG_RELAYCLOSE		(unsigned char)0x50
#define WATCHDOG_RELAYOPEN		(unsigned char)0x51
#define WATCHDOG_TEMPERATURE	(unsigned char)0x58

/* canned replys */

#define WATCHDOG_ACK			(unsigned char)0x06
#define WATCHDOG_NACK1			(unsigned char)0x15
#define WATCHDOG_NACK2			(unsigned char)0x16
#define WATCHDOG_ARMED			(unsigned char)0x20
#define WATCHDOG_PREARMED		(unsigned char)0x21

/* Buffer lengths */

#define WATCHDOG_SENDBUFFER_SIZE	(size_t)5
#define WATCHDOG_RECBUFFER_SIZE		(size_t)4

/*
 * pretty print results in debug mode.
 * saves having to #ifdef DEBUG every 3rd
 * line in the code.
 */

#ifdef DEBUG

#	define debug_msg( msg )				{ fprintf( stderr, "%s\n", msg  ); }
#	define debug_str( msg, string )		{ fprintf( stderr, "%s:  %s\n", msg, string  ); }
#	define debug_value( msg, value )	{ fprintf( stderr, "%s:  %d\n", msg, value  ); }
#	define debug_byte( msg, byte )		{ fprintf( stderr, "%s:  %d ( %#02x )\n", msg, byte, byte  ); }
#	define debug_cmd( msg, cmd )		{ fprintf( stderr, "Sending Command: %s (%#02X)\n", msg, cmd ); }

#else

#	define debug_msg( msg ) 			(void *)NULL
#	define debug_str( msg, string )		(void *)NULL
#	define debug_value( msg, value )	(void *)NULL
#	define debug_byte( msg, byte )		(void *)NULL
#	define debug_cmd( msg, cmd )		(void *)NULL

#endif

/* 
 * defaults.
 */

#define MAX_FILENAME_LEN	256

#define ERROR_LIMIT			128
